package com.trendmicro;

import com.trendmicro.grid.acl.client.ServiceClient;
import com.trendmicro.grid.acl.l0.PublicAuthenticationService;
import com.trendmicro.grid.acl.l0.PublicFileService;
import com.trendmicro.grid.acl.l0.datatypes.FileIdentifier;
import com.trendmicro.grid.acl.l0.datatypes.FileInformation;

/**
 * TODO: Describe it.
 *
 * @author YourName, YYYY-MM-DD
 * @version 1.0
 */
public class Main {
	public static void main(String[] args) throws Exception {
		if (args.length != 2) {
			throw new Exception("Invalid input, 2 argument: [hostname:port] [SHA1] are expected.\n" +
				"Example: java -jar cli.jar gacl.trendmicro.com f00aa51c2ed8b2f656318fdc01ee1cf5441011a4");
		}
			
		boolean useSSL = false;
		String[] hostname = args[0].split(":");
		ServiceClient client = new ServiceClient(hostname[0], (hostname.length < 2 ? -1 : Integer.parseInt(hostname[1])), useSSL);

		PublicAuthenticationService authService = client.getPort(PublicAuthenticationService.class);
		if (!authService.isAuthenticated())
			authService.authenticate("guest", new char[]{'p', 'w'});

		PublicFileService fileService = client.getPort(PublicFileService.class);
		FileIdentifier fid = new FileIdentifier(args[1]);
		FileInformation info = fileService.getFileInformation(fid);

		System.out.println(info);
	}
}
